define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.constant('HealthMoodServiceConstants', {
		'glucose': {
			extensions: {
				object: {
					uidKey: '_id',
					dateKey: [{ from: 'recorded' }],
					supportsLatest: true,
					defaults: {
						name: 'Glucose',
						method: 'Unknown',
						valueQuantity: {
							units: 'mg/dl'
						}
					}
				},
				dependency: {
					linkTitles: {
						GET: 'observations-glucose',
						POST: 'observations'
					}
				},
				collection: {
					name: 'observation',
					objectType: 'Observations'
				}
			}
		},
		"cholesterol" : {
	        extensions : {
	            object : {
	                uidKey : "_id",
	                dateKey : [{ from : "updated" }],
					supportsLatest: true,
	                defaults : {
	                    name: "Lipids",
	                    entry: [{ name: "Total Serum Cholesterol", valueQuantity: {
							units: 'mg/dl'
						} }, { name: "LDL", valueQuantity: {
							units: 'mg/dl'
						} }, { name: "HDL", valueQuantity: {
							units: 'mg/dl'
						} }, { name: "Triglycerides", valueQuantity: {
							units: 'mg/dl'
						} }]
	                }
	            },
	            dependency : {
	                linkTitles : {
	                    GET : "observations-bundle-cholesterol",
	                    POST : "observations-bundle"
	                }
	            },
	            collection : {
	                name : "observation",
	                objectType : "ObservationBundles"
	            }
	        }
	    },
		"mood" : {
			extensions : {
				object : {
                    uidKey : "_id",
                    dateKey : [{ from : "recorded" }],
					supportsLatest: true,
					defaults : {
                        name: "Mood",
						valueQuantity: {
                            value: "",
							units: 'NA'
                        }
					}
				},
				dependency : {
					linkTitles : {
						GET : "mood",
						POST : "mood"
					}
				},
				collection : {
					name : "observation",
					objectType : "Observations"
				}
			}
		},
        "bp-pulse" : {
            extensions : {
                object : {
                    uidKey: '_id',
					dateKey : [{ from : "updated" }],
					supportsLatest: true,
					defaults: {
						name: "BloodPressureAndPulse",
						method: "",
						entry: [
							{
								valueQuantity: {
									units: "mmHg"
								},
								name: "8480-6"
							},
							{
								valueQuantity: {
									units: "mmHg"
								},
								name: "8462-4"
							},
							{
								valueQuantity: {
									units: "bpm"
								},
								name: "8867-4"
							}
						]
                    }
                },
                dependency : {
                    linkTitles : {
                        GET : "vital-signs-bundle-bp",
						POST : "vital-signs-bundle"
                    }
                },
                collection : {
                    name : "observation",
					objectType : "ObservationBundles"
                }
            }
        },
		"weight" : {
			extensions : {
				object : {
					uidKey: '_id',
					dateKey : [{ from : "recorded" }],
					supportsLatest: true,
					defaults : {
         				name : "Weight",
						valueQuantity: {
							units: "lbs"
						}
					}
				},
				dependency : {
					linkTitles : {
						GET : "vital-signs-weight",
						POST : "vital-signs"
					}
				},
				collection : {
					name: 'observation',
					objectType: 'Observations'
				}
			}
		}
	});

	app.constant('HealthMoodRemindersConstants', {
		'bp-pulse-reminders': {
			dependency : {
				linkTitles : {
					GET : 'reminders-bp-pulse',
					POST : 'reminders'
				}
			},
			object : {
				defaults : {
					source : 'VA FitHeart - Health - Blood Pressure and Pulse'
				}
			}
		},
		'glucose-reminders': {
			dependency : {
				linkTitles : {
					GET : 'reminders-glucose',
					POST : 'reminders'
				}
			},
			object : {
				defaults : {
					source : 'VA FitHeart - Health - Glucose'
				}
			}
		},
		'weight-reminders': {
			dependency : {
				linkTitles : {
					GET : 'reminders-weight',
					POST : 'reminders'
				}
			},
			object : {
				defaults : {
					source : 'VA FitHeart - Health - Weight'
				}
			}
		},
		'cholesterol-reminders': {
			dependency : {
				linkTitles : {
					GET : 'reminders-cholesterol',
					POST : 'reminders'
				}
			},
			object : {
				defaults : {
					source : 'VA FitHeart - Health - Cholesterol'
				}
			}
		},
		'mood-reminders': {
			dependency : {
				linkTitles : {
					GET : 'reminders-mood',
					POST : 'reminders'
				}
			},
			object : {
				defaults : {
					source : 'VA FitHeart - Health - Mood'
				}
			}
		}
	});
});